<?php

namespace Fir\Controllers;

use Aws\S3\S3Client;

class Requests extends Controller {

    /**
     * @var object
     */
    protected $model;

    public function index() {
        redirect();
    }

    public function search() {
        $model = $this->model('Requests');

        // Get the available locations
		$adminModel = $this->model('Admin');
        $data['currency'] = $adminModel->currencyDetails();
		
        return ['results' => $this->view->render($data, 'requests/search')];
    }

    public function delete_category() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_category($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function delete_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_candidate($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function delete_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }

    public function resume_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->resume_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['resumed_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_resume'];
		 }

        return $response;
    }

    public function finish_voting() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->finish_voting($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['finished_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_finish'];
		 }

        return $response;
    }

    public function approve_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->approve_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['approved_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_approve'];
		 }

        return $response;
    }

    public function decline_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->decline_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['declined_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_decline'];
		 }

        return $response;
    }

    public function approve_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->approve_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['approved_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_approve'];
		 }

        return $response;
    }

    public function decline_candidate() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->decline_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['declined_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_decline'];
		 }

        return $response;
    }

    public function delete_voter() {
        $model = $this->model('Requests');
		$input = $this->library('Input');
		
        $id = $input->get('id');
						
		 $delete = $model->delete_voter($id);
		
		 if ($delete == 1) {
				$response['status']  = $this->lang['success'];
				$response['message'] = $this->lang['deleted_successfully'];
		 } else {
				$response['status']  = $this->lang['error'];
				$response['message'] = $this->lang['unable_to_delete'];
		 }	

        return $response;
    }


	
	//Random String
	public function rando($length = 14){
		$str = "";
		$characters = array_merge(range('A','Z'), range('a','z'), range('0','9'));
		$max = count($characters) - 1;
		for ($i = 0; $i < $length; $i++) {
			$rand = mt_rand(0, $max);
			$str .= $characters[$rand];
		}
		return $str;
	}
		
}